/*
 * Decompiled with CFR 0.152.
 */
package qic.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class.getName());

    public static String removeThoseDamnWhiteSpace(String s) {
        char[] charArray;
        s = StringUtils.deleteWhitespace(s);
        StringBuilder sb = new StringBuilder();
        for (char c : charArray = s.toCharArray()) {
            if (Character.isSpaceChar(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String regexMatch(String regex, String s, int group) {
        List<String> matches;
        if (s != null && !(matches = Util.regexMatches(regex, s, group, 2)).isEmpty()) {
            return matches.get(0);
        }
        return null;
    }

    public static List<String> regexMatches(String regex, String s, int group) {
        return Util.regexMatches(regex, s, group, 2);
    }

    public static List<String> regexMatches(String regex, String s, int group, int flags) {
        ArrayList<String> allMatches = new ArrayList<String>();
        Matcher m = Pattern.compile(regex, flags).matcher(s);
        while (m.find()) {
            allMatches.add(m.group(group));
        }
        return allMatches;
    }

    public static String encodeQueryParm(String queryParam) {
        String key = StringUtils.substringBefore(queryParam, "=");
        String value = StringUtils.substringAfter(queryParam, "=");
        try {
            value = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return key + "=" + value;
    }

    public static void overwriteFile(String fileName, String contents) throws IOException {
        File file = new File(fileName);
        Util.overwriteFile(file, contents);
    }

    public static void overwriteFile(File file, String contents) throws IOException {
        FileUtils.writeStringToFile(file, contents, "UTF-8", false);
    }

    public static String toJsonPretty(Object obj) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson(obj);
    }

    public static List<String> loadSearchList(String filename) {
        try {
            List<String> lines = FileUtils.readLines(new File(filename));
            lines = lines.stream().filter(s -> StringUtils.isNotBlank(s) && !s.startsWith(";")).collect(Collectors.toList());
            return lines;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }
}

