/*
 * Decompiled with CFR 0.152.
 */
package qic.util;

import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.net.URI;
import qic.util.BlackmarketException;
import qic.util.SimpleExceptionHandler;

public class SwingUtil {
    public static void openUrlViaBrowser(String url) {
        String s = url;
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(s));
            }
            catch (Exception e) {
                SwingUtil.showError(new BlackmarketException("Error on opening browser, address: " + s + ": " + e.getMessage(), e));
            }
        } else {
            SwingUtil.showError(new BlackmarketException("Launch browser failed, please manually visit: " + s));
        }
    }

    public static void copyToClipboard(String s) {
        StringSelection stringSelection = new StringSelection(s);
        Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
        clpbrd.setContents(stringSelection, null);
    }

    public static void showError(Throwable e) {
        new SimpleExceptionHandler().uncaughtException(Thread.currentThread(), e);
    }
}

