/*
 * Decompiled with CFR 0.152.
 */
package qic.util;

import java.util.Random;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class SoundUtils {
    public static float SAMPLE_RATE = 8000.0f;

    public static void laser(int repeat) throws LineUnavailableException, InterruptedException {
        AudioFormat af = new AudioFormat(SAMPLE_RATE, 8, 1, true, false);
        SourceDataLine sdl = AudioSystem.getSourceDataLine(af);
        sdl.open(af);
        sdl.start();
        byte[] buf = new byte[1];
        for (int j = 0; j < repeat; ++j) {
            int step = 10;
            for (int i = 0; i < 2000; ++i) {
                int n = buf[0] = i % step > 0 ? 32 : 0;
                if (i % 250 == 0) {
                    step += 2;
                }
                sdl.write(buf, 0, 1);
            }
            Thread.sleep(200L);
        }
        sdl.drain();
        sdl.stop();
        sdl.close();
    }

    public static void warp(int repeat) throws LineUnavailableException, InterruptedException {
        AudioFormat af = new AudioFormat(SAMPLE_RATE, 8, 1, true, false);
        SourceDataLine sdl = AudioSystem.getSourceDataLine(af);
        sdl.open(af);
        sdl.start();
        byte[] buf = new byte[1];
        for (int j = 0; j < repeat; ++j) {
            int step = 25;
            for (int i = 0; i < 2000; ++i) {
                if (i < 500) {
                    int n = buf[0] = i % step > 0 ? 32 : 0;
                    if (i % 25 == 0) {
                        --step;
                    }
                } else {
                    int n = buf[0] = i % step > 0 ? 16 : 0;
                    if (i % 50 == 0) {
                        ++step;
                    }
                }
                sdl.write(buf, 0, 1);
            }
        }
        sdl.drain();
        sdl.stop();
        sdl.close();
    }

    public static void bang() throws LineUnavailableException, InterruptedException {
        AudioFormat af = new AudioFormat(SAMPLE_RATE, 8, 1, true, false);
        SourceDataLine sdl = AudioSystem.getSourceDataLine(af);
        sdl.open(af);
        sdl.start();
        byte[] buf = new byte[1];
        Random r = new Random();
        boolean silence = true;
        for (int i = 0; i < 8000; ++i) {
            while (r.nextInt() % 10 != 0) {
                buf[0] = silence ? (byte)0 : (byte)Math.abs(r.nextInt() % (int)(1.0 + 63.0 * (1.0 + Math.cos((double)i * Math.PI / 8000.0))));
                ++i;
                sdl.write(buf, 0, 1);
            }
            silence = !silence;
        }
        sdl.drain();
        sdl.stop();
        sdl.close();
    }

    public static void main(String[] args) throws Exception {
        SoundUtils.laser(5);
        Thread.sleep(1000L);
        SoundUtils.warp(10);
        Thread.sleep(1000L);
        SoundUtils.bang();
        SoundUtils.tone(5000, 100);
        Thread.sleep(1000L);
    }

    public static void tone(int hz, int msecs) throws LineUnavailableException {
        SoundUtils.tone(hz, msecs, 1.0);
    }

    public static void tone(int hz, int msecs, double vol) throws LineUnavailableException {
        byte[] buf = new byte[1];
        AudioFormat af = new AudioFormat(SAMPLE_RATE, 8, 1, true, false);
        SourceDataLine sdl = AudioSystem.getSourceDataLine(af);
        sdl.open(af);
        sdl.start();
        for (int i = 0; i < msecs * 8; ++i) {
            double angle = (double)((float)i / (SAMPLE_RATE / (float)hz)) * 2.0 * Math.PI;
            buf[0] = (byte)(Math.sin(angle) * 127.0 * vol);
            sdl.write(buf, 0, 1);
        }
        sdl.drain();
        sdl.stop();
        sdl.close();
    }
}

