/*
 * Decompiled with CFR 0.152.
 */
package qic.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import qic.ui.extra.CaptchaDetectedException;
import qic.ui.extra.JButtonLink;

public class SimpleExceptionHandler
implements Thread.UncaughtExceptionHandler {
    @Override
    public void uncaughtException(final Thread thread, final Throwable throwable) {
        String formattedMessage = this.format(thread, throwable);
        if (formattedMessage == null || formattedMessage.trim().length() == 0) {
            formattedMessage = "An error has occurred but no further details are available.";
        }
        if (!GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.reportInGUI(thread, throwable);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            SimpleExceptionHandler.this.reportInGUI(thread, throwable);
                        }
                    });
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                catch (InvocationTargetException ite) {
                    ite.getCause().printStackTrace();
                }
            }
        }
    }

    public String format(Thread thread, Throwable throwable) {
        return SimpleExceptionHandler.simpleFormat(thread, throwable);
    }

    public void reportInGUI(Thread thread, Throwable throwable) {
        JDialog dialog = new SimpleExceptionPane(thread, throwable).createDialog(null, "An error has occurred.");
        dialog.setResizable(true);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static String simpleFormat(Thread thread, Throwable throwable) {
        StringBuilder buffer = new StringBuilder();
        if (thread != null) {
            buffer.append("An error has occurred in thread #").append(thread.getId()).append(": ").append(thread.getName());
        }
        if (throwable != null) {
            StringWriter writer = new StringWriter();
            throwable.printStackTrace(new PrintWriter(writer));
            String stackTrace = writer.toString();
            if (stackTrace != null && !"null".equalsIgnoreCase(stackTrace.trim()) && stackTrace.trim().length() != 0) {
                if (buffer.length() == 0) {
                    buffer.append("An error has occurred");
                }
                buffer.append("; please find details below:").append(System.lineSeparator()).append(System.lineSeparator()).append(stackTrace);
            }
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        new SimpleExceptionHandler().uncaughtException(Thread.currentThread(), new IllegalArgumentException("This is not good! Who you gonna call??? Ghost Busters!"));
        Thread.setDefaultUncaughtExceptionHandler(new SimpleExceptionHandler());
        throw new IllegalArgumentException(new NullPointerException("Stop passing me nulls! ;)"));
    }

    public static class SimpleExceptionPane
    extends JOptionPane {
        private static final long serialVersionUID = 1020140128L;

        public SimpleExceptionPane(Thread thread, Throwable throwable) {
            String exceptionMessage;
            JPanel messagePnl = new JPanel();
            messagePnl.setLayout(new BoxLayout(messagePnl, 3));
            messagePnl.add(Box.createRigidArea(new Dimension(0, 10)));
            JLabel genericMessageLbl = new JLabel("An error has occurred:");
            genericMessageLbl.setAlignmentX(0.0f);
            messagePnl.add(genericMessageLbl);
            String string = exceptionMessage = throwable != null ? throwable.getMessage() : null;
            if (exceptionMessage != null && exceptionMessage.trim().length() != 0) {
                messagePnl.add(Box.createRigidArea(new Dimension(0, 10)));
                messagePnl.add(new JLabel(exceptionMessage));
            }
            if (throwable instanceof CaptchaDetectedException) {
                messagePnl.add(Box.createRigidArea(new Dimension(0, 10)));
                CaptchaDetectedException captchaEx = (CaptchaDetectedException)throwable;
                messagePnl.add(new JButtonLink("Open Captcha Page", captchaEx.getUrl()));
            }
            messagePnl.add(Box.createRigidArea(new Dimension(0, 10)));
            String details = SimpleExceptionHandler.simpleFormat(thread, throwable);
            if (details == null || details.length() == 0) {
                JLabel detailsLbl = new JLabel("No further details are available.");
                detailsLbl.setAlignmentX(0.0f);
                messagePnl.add(detailsLbl);
            } else {
                JTextArea detailsTxA = new JTextArea(details, 10, 100);
                detailsTxA.setEditable(false);
                final JScrollPane detailsCmp = new JScrollPane(detailsTxA, 20, 30);
                detailsCmp.setAlignmentX(0.0f);
                detailsCmp.setVisible(false);
                String detailsBtnText = "\u00bb Details";
                final JLabel detailsBtn = new JLabel("<html>\u00bb Details");
                detailsBtn.setFocusable(true);
                detailsBtn.setForeground(Color.blue);
                detailsBtn.setAlignmentX(0.0f);
                detailsBtn.setCursor(Cursor.getPredefinedCursor(12));
                detailsBtn.addFocusListener(new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        detailsBtn.setText("<html><u>\u00bb Details");
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        detailsBtn.setText("<html>\u00bb Details");
                    }
                });
                detailsBtn.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent evt) {
                        if (evt.getKeyCode() == 10) {
                            this.toggleDetails(detailsCmp);
                        }
                    }
                });
                detailsBtn.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent evt) {
                        this.toggleDetails(detailsCmp);
                    }
                });
                messagePnl.add(detailsBtn);
                messagePnl.add(Box.createRigidArea(new Dimension(0, 10)));
                messagePnl.add(detailsCmp);
            }
            this.setMessage(messagePnl);
            this.setMessageType(0);
            this.setOptions(new String[]{"Close"});
        }

        protected void toggleDetails(JComponent detailsCmp) {
            detailsCmp.setVisible(!detailsCmp.isVisible());
            Window window = SwingUtilities.getWindowAncestor(this);
            if (detailsCmp.isVisible()) {
                window.setSize(650, 350);
            } else {
                window.pack();
            }
        }
    }
}

