/*
 * Decompiled with CFR 0.152.
 */
package qic.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.Files;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageCache {
    private final Logger logger = LoggerFactory.getLogger(this.getClass().getName());
    private static final ImageCache INSTANCE = new ImageCache();
    private LoadingCache<String, ImageIcon> imageCache = CacheBuilder.newBuilder().maximumSize(300L).build(new ImageCacheLoader());

    private ImageCache() {
    }

    public static ImageCache getInstance() {
        return INSTANCE;
    }

    public ImageIcon get(String key) {
        ImageIcon image = null;
        if (StringUtils.isNotBlank(key)) {
            try {
                image = this.imageCache.get(key);
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                this.logger.warn("Exception in loading image: " + key + ". Returning default image.", e);
            }
        }
        return image;
    }

    public void preLoad(String key) {
        this.get(key);
    }

    private static class ImageCacheLoader
    extends CacheLoader<String, ImageIcon> {
        private ImageCacheLoader() {
        }

        @Override
        public ImageIcon load(String key) throws Exception {
            File imagesDirectory = new File("images");
            if (!imagesDirectory.exists()) {
                imagesDirectory.mkdir();
            }
            String fileName = null;
            BufferedImage image = null;
            URL url = new URL(key);
            fileName = url.toURI().getRawPath();
            File imageFile = new File(imagesDirectory, fileName);
            if (imageFile.exists()) {
                image = ImageIO.read(imageFile);
            } else {
                image = ImageIO.read(new URL(key));
                this.saveToDisk(fileName, image, imageFile);
            }
            return new ImageIcon(image);
        }

        private void saveToDisk(String fileName, Image image, File imageFile) throws IOException {
            Files.createParentDirs(imageFile);
            BufferedImage bufferedImage = (BufferedImage)image;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, StringUtils.substringAfterLast(fileName, "."), baos);
            baos.flush();
            byte[] imageInByte = baos.toByteArray();
            baos.close();
            Files.write(imageInByte, imageFile);
        }
    }
}

