/*
 * Decompiled with CFR 0.152.
 */
package qic.util;

import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qic.BackendClient;
import qic.SearchPageScraper;
import qic.util.Config;
import qic.util.Verify;

public class DurianUtils {
    private static final Logger logger = LoggerFactory.getLogger(DurianUtils.class.getName());

    public static boolean notBlacklisted(String key, SearchPageScraper.SearchResultItem item) {
        String blacklistStr = Config.getPropety(key, "");
        boolean isBlacklisted = Arrays.asList(blacklistStr.split(",")).stream().anyMatch(s -> s.equalsIgnoreCase(item.seller()));
        return !isBlacklisted;
    }

    public static Verify verify(String thread, String dataHash) {
        String url = String.format("http://verify.xyz.is/%s/%s", thread, dataHash);
        String callback_name = "__callback_" + new Date().getTime() + "_" + Math.floor(Math.random() * 1000.0);
        String underscoreValue = String.valueOf(Math.random() * 1000.0);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("callback", callback_name);
        parameters.put("_", underscoreValue);
        String verifyRaw = null;
        try {
            verifyRaw = DurianUtils.getVerifyAndRetry(url, parameters, verifyRaw);
        }
        catch (UnirestException e) {
            return Verify.ERROR;
        }
        String result = StringUtils.substringBetween(verifyRaw, callback_name + "(", ");");
        boolean verified = Boolean.parseBoolean(result);
        return verified ? Verify.VERIFIED : Verify.SOLD;
    }

    private static String getVerifyAndRetry(String url, Map<String, Object> parameters, String verifyRaw) throws UnirestException {
        int count = 0;
        int maxTries = 10;
        String[] userAgents = BackendClient.userAgents;
        while (true) {
            try {
                verifyRaw = Unirest.get(url).header("Host", "verify.xyz.is").header("User-Agent", userAgents[RandomUtils.nextInt(0, userAgents.length)]).header("Accept", "*/*").header("Accept-Language", "en-US,enq=0.5").header("Connection", "keep-alive").header("Accept-Encoding", "gzip, deflate").queryString(parameters).asString().getBody();
                return verifyRaw;
            }
            catch (UnirestException e) {
                if (++count != maxTries) continue;
                logger.error(String.format("Failed to verify using url %s, re-tried %d times.", url, maxTries), e);
                throw e;
            }
            break;
        }
    }
}

