/*
 * Decompiled with CFR 0.152.
 */
package qic.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CommandLine {
    private String[] _arguments = null;
    private Map _flags = new HashMap();
    private Set _flagsWithValues = new HashSet();

    public CommandLine(String[] args) {
        this.parse(args);
    }

    public String[] getArguments() {
        return this._arguments;
    }

    public String getFlagValue(String flagName) {
        return (String)this._flags.get(flagName);
    }

    public int getNumberOfArguments() {
        return this._arguments.length;
    }

    public int getNumberOfFlags() {
        return this._flags.size();
    }

    public boolean hasFlag(String flagName) {
        return this._flags.containsKey(flagName);
    }

    public void parse(String[] args) {
        ArrayList<String> regularArgs = new ArrayList<String>();
        for (int n = 0; n < args.length; ++n) {
            if (args[n].charAt(0) == '-') {
                String name = args[n];
                String value = null;
                if (this._flagsWithValues.contains(args[n]) && n < args.length - 1) {
                    value = args[++n];
                }
                this._flags.put(name, value);
                continue;
            }
            regularArgs.add(args[n]);
        }
        int size = regularArgs.size();
        this._arguments = regularArgs.toArray(new String[size]);
    }

    public void saveFlagValue(String flagName) {
        this._flagsWithValues.add(flagName);
    }

    public String getArgument(int i) {
        if (this.getNumberOfArguments() < i + 1) {
            return null;
        }
        return this.getArguments()[i];
    }
}

