/*
 * Decompiled with CFR 0.152.
 */
package qic.ui.extra;

import java.util.List;
import java.util.function.Consumer;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qic.SearchPageScraper;
import qic.util.DurianUtils;
import qic.util.Util;
import qic.util.Verify;

public class VerifierTask
extends SwingWorker<Integer, SearchPageScraper.SearchResultItem> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass().getName());
    private Consumer<Integer> resultConsumer;
    private Consumer<Exception> onException;
    private Consumer<List<SearchPageScraper.SearchResultItem>> consumer;
    private List<SearchPageScraper.SearchResultItem> itemResults;
    private long sleep = -1L;
    private boolean skipIfSold = false;

    public VerifierTask(List<SearchPageScraper.SearchResultItem> itemResults, Consumer<List<SearchPageScraper.SearchResultItem>> consumer, Consumer<Integer> resultConsumer, Consumer<Exception> onException, long sleep, boolean skipIfSold) {
        this.itemResults = itemResults;
        this.consumer = consumer;
        this.resultConsumer = resultConsumer;
        this.onException = onException;
        this.sleep = sleep;
        this.skipIfSold = skipIfSold;
    }

    public VerifierTask(List<SearchPageScraper.SearchResultItem> itemResults, Consumer<List<SearchPageScraper.SearchResultItem>> consumer, Consumer<Integer> resultConsumer, Consumer<Exception> onException) {
        this.itemResults = itemResults;
        this.consumer = consumer;
        this.resultConsumer = resultConsumer;
        this.onException = onException;
    }

    @Override
    protected Integer doInBackground() {
        int countAfterVerify = this.runVerify(this.itemResults);
        return countAfterVerify;
    }

    private int runVerify(List<SearchPageScraper.SearchResultItem> itemResults) {
        return itemResults.stream().mapToInt(item -> {
            boolean skip;
            int result = 0;
            this.logger.info(String.format("Verifying item %s", item.toShortDebugInfo()));
            Verify verified = DurianUtils.verify(item.thread(), item.dataHash());
            item.verified(verified);
            this.logger.info(String.format("Verify result for item %s: %s", new Object[]{item.toShortDebugInfo(), verified}));
            boolean bl = skip = this.skipIfSold && verified == Verify.SOLD;
            if (!skip) {
                this.publish(item);
            }
            if (verified == Verify.VERIFIED) {
                result = 1;
            }
            if (this.sleep != -1L) {
                this.logger.info(String.format("Verify - now sleeping for %s millisec", this.sleep));
                Util.sleep(this.sleep);
            }
            return result;
        }).sum();
    }

    @Override
    protected void process(List<SearchPageScraper.SearchResultItem> itemResults) {
        this.consumer.accept(itemResults);
    }

    @Override
    protected void done() {
        try {
            this.resultConsumer.accept((Integer)this.get());
        }
        catch (Exception e) {
            this.onException.accept(e);
        }
    }
}

