/*
 * Decompiled with CFR 0.152.
 */
package qic.ui.extra;

import com.porty.swing.table.model.BeanPropertyTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import qic.SearchPageScraper;

public class MultiLineTableCellRenderer
extends JTextArea
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private List<List<Integer>> rowColHeight = new ArrayList<List<Integer>>();
    private static final EmptyBorder EMPTY_BORDER = new EmptyBorder(1, 2, 1, 2);
    private Color bgColor;
    private Color guildColor;
    private Color autoHighlightColor;
    private BeanPropertyTableModel<SearchPageScraper.SearchResultItem> model;

    public MultiLineTableCellRenderer(BeanPropertyTableModel<SearchPageScraper.SearchResultItem> model, Color bgColor, Color guildColor, Color autoHighlightColor) {
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.setOpaque(true);
        this.bgColor = bgColor;
        this.guildColor = guildColor;
        this.autoHighlightColor = autoHighlightColor;
        this.model = model;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(this.bgColor != null ? this.bgColor : table.getBackground());
            if (!this.model.getData().isEmpty()) {
                SearchPageScraper.SearchResultItem item = this.model.getData().get(row);
                if (item.newInAutomated()) {
                    this.setBackground(this.autoHighlightColor);
                } else if (item.guildItem()) {
                    this.setBackground(this.guildColor);
                }
            }
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(EMPTY_BORDER);
        }
        if (value != null) {
            if (value instanceof List) {
                List list = (List)value;
                String s = StringUtils.join(list, System.lineSeparator());
                this.setText(s);
            } else {
                this.setText(value.toString());
            }
        } else {
            this.setText("");
        }
        this.adjustRowHeight(table, row, column);
        return this;
    }

    private void adjustRowHeight(JTable table, int row, int column) {
        int cWidth = table.getTableHeader().getColumnModel().getColumn(column).getWidth();
        this.setSize(new Dimension(cWidth, 1000));
        int prefH = this.getPreferredSize().height;
        while (this.rowColHeight.size() <= row) {
            this.rowColHeight.add(new ArrayList(column));
        }
        List<Integer> colHeights = this.rowColHeight.get(row);
        while (colHeights.size() <= column) {
            colHeights.add(0);
        }
        colHeights.set(column, prefH);
        int maxH = prefH;
        for (Integer colHeight : colHeights) {
            if (colHeight <= maxH) continue;
            maxH = colHeight;
        }
        if (table.getRowHeight(row) < maxH) {
            table.setRowHeight(row, maxH);
        }
    }
}

