/*
 * Decompiled with CFR 0.152.
 */
package qic.ui.extra;

import com.porty.swing.table.model.BeanPropertyTableModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import qic.SearchPageScraper;
import qic.util.Config;

public class ArtColumnRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private Color bgColor;
    private Color guildColor;
    private Color autoHighlightColor;
    private BeanPropertyTableModel<SearchPageScraper.SearchResultItem> model;

    public ArtColumnRenderer(BeanPropertyTableModel<SearchPageScraper.SearchResultItem> model, Color bgColor, Color guildColor, Color autoHighlightColor) {
        this.bgColor = bgColor;
        this.guildColor = guildColor;
        this.autoHighlightColor = autoHighlightColor;
        this.model = model;
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setText("");
        this.setIcon(null);
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(this.bgColor != null ? this.bgColor : table.getBackground());
            if (!this.model.getData().isEmpty()) {
                SearchPageScraper.SearchResultItem item = this.model.getData().get(row);
                if (item.newInAutomated()) {
                    this.setBackground(this.autoHighlightColor);
                } else if (item.guildItem()) {
                    this.setBackground(this.guildColor);
                }
            }
        }
        boolean artEnabled = Config.getBooleanProperty("result.table.art.enabled", true);
        if (artEnabled && value != null) {
            ImageIcon image = (ImageIcon)value;
            this.setIcon(image);
        }
        return this;
    }
}

