/*
 * Decompiled with CFR 0.152.
 */
package qic.ui;

import com.porty.swing.table.model.BeanPropertyTableModel;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qic.SearchPageScraper;
import qic.ui.extra.ArtColumnRenderer;
import qic.ui.extra.MultiLineTableCellRenderer;
import qic.ui.extra.VerifierTask;
import qic.util.Config;
import qic.util.SwingUtil;

public class SearchResultTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass().getName());
    private BeanPropertyTableModel<SearchPageScraper.SearchResultItem> model = new BeanPropertyTableModel(SearchPageScraper.SearchResultItem.class);
    private VerifierTask autoVerifierTask;

    public SearchResultTable() {
        this.model.setOrderedProperties(Arrays.asList("art", "bo", "item", "seller", "reqs", "mods", "offense", "defense"));
        this.setModel(this.model);
        this.setupColumnWidths();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                Point p;
                JTable table = (JTable)me.getSource();
                int row = table.rowAtPoint(p = me.getPoint());
                if (row > -1) {
                    SearchPageScraper.SearchResultItem searchResultItem;
                    if (SwingUtilities.isLeftMouseButton(me)) {
                        searchResultItem = (SearchPageScraper.SearchResultItem)SearchResultTable.this.model.getData().get(row);
                        SwingUtil.copyToClipboard(searchResultItem.wtb());
                    }
                    if (SwingUtilities.isRightMouseButton(me)) {
                        searchResultItem = (SearchPageScraper.SearchResultItem)SearchResultTable.this.model.getData().get(row);
                        VerifierTask manualVerifierTask = new VerifierTask(Arrays.asList(searchResultItem), results -> SearchResultTable.this.updateData(row), verified -> {}, ex -> SearchResultTable.this.logger.error("Error while running manual verify", (Throwable)ex));
                        manualVerifierTask.execute();
                    }
                }
            }
        });
        Color bgColor = Color.decode(Config.getPropety("result.table.bg.color", null));
        Color guildColor = Color.decode(Config.getPropety("guild.color.highlight", "#f6b67f"));
        Color autoHighlightColor = Color.decode(Config.getPropety("automated.search.notify.newonly.color.highlight", "#ccff99"));
        this.setDefaultRenderer(List.class, new MultiLineTableCellRenderer(this.model, bgColor, guildColor, autoHighlightColor));
        this.setDefaultRenderer(String.class, new MultiLineTableCellRenderer(this.model, bgColor, guildColor, autoHighlightColor));
        this.setDefaultRenderer(ImageIcon.class, new ArtColumnRenderer(this.model, bgColor, guildColor, autoHighlightColor));
        this.model.addTableModelListener(e -> {
            boolean artEnabled = Config.getBooleanProperty("result.table.art.enabled", true);
            if (artEnabled) {
                for (int i = 0; i < this.model.getData().size(); ++i) {
                    SearchPageScraper.SearchResultItem item = this.model.getData().get(i);
                    ImageIcon art = item.getArt();
                    if (art == null) continue;
                    int height = art.getIconHeight();
                    this.setRowHeight(i, height);
                }
            }
        });
    }

    private void setupColumnWidths() {
        this.setColumnWidths(this.getColumnModel(), Arrays.asList(115, 20, 205, 135, 50, 340, 90, 90));
    }

    private void setColumnWidths(TableColumnModel columnModel, List<Integer> widths) {
        for (int i = 0; i < widths.size(); ++i) {
            columnModel.getColumn(i).setMinWidth(widths.get(i));
        }
    }

    public void setData(List<SearchPageScraper.SearchResultItem> itemResults) {
        List<SearchPageScraper.SearchResultItem> data = this.model.getData();
        data.clear();
        data.addAll(itemResults);
        this.model.fireTableDataChanged();
        this.setupColumnWidths();
    }

    public void updateData(int index) {
        this.model.fireTableRowsUpdated(index, index);
    }

    public void addData(List<SearchPageScraper.SearchResultItem> itemResults) {
        List<SearchPageScraper.SearchResultItem> data = this.model.getData();
        int sidx = data.size() - 1;
        data.addAll(itemResults);
        int eidx = data.size() - 1;
        this.model.fireTableRowsInserted(sidx, eidx);
        this.setupColumnWidths();
    }

    public void clear() {
        this.model.getData().clear();
        this.model.fireTableDataChanged();
    }

    public void runAutoVerify(long sleep) {
        this.runAutoVerify(sleep, i -> this.logger.info(String.format("Verified %d items.", i)), ex -> this.logger.error("Error while running Automated Verify", (Throwable)ex));
    }

    public void runAutoVerify(long sleep, Consumer<Integer> onComplete, Consumer<Exception> onException) {
        Consumer<List<SearchPageScraper.SearchResultItem>> consumer = itemList -> itemList.stream().map(item -> this.model.getData().indexOf(item)).forEach(this::updateData);
        if (this.autoVerifierTask != null) {
            this.autoVerifierTask.cancel(true);
        }
        this.autoVerifierTask = new VerifierTask(this.model.getData(), consumer, onComplete, onException, sleep, false);
        this.autoVerifierTask.execute();
    }
}

