/*
 * Decompiled with CFR 0.152.
 */
package qic.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import org.apache.commons.io.FileUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qic.ui.extra.FileTreeModel;
import qic.util.SwingUtil;
import qic.util.Util;

public class ScriptsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass().getName());
    private RSyntaxTextArea textArea;
    private JTree fileTree;
    private File currentScript;

    public ScriptsPanel() {
        this.setLayout(new BorderLayout());
        this.setupTextArea();
        this.setupFileTree();
        this.textArea.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ScriptsPanel.this.saveCurrentScriptToFile();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void setupFileTree() {
        FileTreeModel model = new FileTreeModel(new File("script"));
        this.fileTree = new JTree(model);
        this.fileTree.getSelectionModel().setSelectionMode(1);
        this.fileTree.addTreeSelectionListener(tse -> {
            File file = (File)this.fileTree.getLastSelectedPathComponent();
            if (this.isFileEditable(file)) {
                this.saveCurrentScriptToFile();
                this.currentScript = file;
                this.loadFileToTextArea(file);
            }
        });
        this.fileTree.setSelectionRow(this.fileTree.getRowCount() > 3 ? 3 : 1);
        this.add((Component)new JScrollPane(this.fileTree), "East");
    }

    private boolean isFileEditable(File file) {
        if (file != null && file.isFile()) {
            boolean isAudio = file.getName().endsWith(".wav") || file.getName().endsWith(".mp3");
            return !isAudio;
        }
        return false;
    }

    private void setupTextArea() {
        this.textArea = new RSyntaxTextArea(20, 60);
        this.textArea.setSyntaxEditingStyle("text/javascript");
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setFont(new Font("Consolas", 0, 12));
        this.add((Component)new RTextScrollPane(this.textArea), "Center");
    }

    void saveCurrentScriptToFile() {
        if (this.currentScript != null) {
            try {
                Util.overwriteFile(this.currentScript, this.textArea.getText());
            }
            catch (IOException e) {
                this.logger.error(e.getMessage(), e);
                SwingUtil.showError(e);
            }
        }
    }

    private void loadFileToTextArea(File file) {
        try {
            String str = FileUtils.readFileToString(file, "UTF-8");
            this.textArea.setText(str);
            this.textArea.setCaretPosition(0);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            SwingUtil.showError(e);
        }
    }
}

