/*
 * Decompiled with CFR 0.152.
 */
package qic.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qic.Main;
import qic.ui.AboutPanel;
import qic.ui.AutomatedPanel;
import qic.ui.ConfigPanel;
import qic.ui.GuildPanel;
import qic.ui.LoggerPanel;
import qic.ui.ManualPanel;
import qic.ui.ScriptsPanel;
import qic.ui.TermsPanel;
import qic.util.SoundUtilsFX;

public class QicFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass().getName());

    public QicFrame(Main main, String query) {
        super("Durian 0.6.0");
        Image icon = Toolkit.getDefaultToolkit().getImage(QicFrame.class.getResource("/durian128.png"));
        this.setIconImage(icon);
        SoundUtilsFX.init();
        final ManualPanel manualPanel = new ManualPanel(main);
        final AutomatedPanel automatedPanel = new AutomatedPanel(main);
        LoggerPanel loggerPanel = new LoggerPanel();
        final ConfigPanel configPanel = new ConfigPanel();
        final TermsPanel termsPanel = new TermsPanel();
        final ScriptsPanel scriptsPanel = new ScriptsPanel();
        GuildPanel guildPanel = new GuildPanel();
        AboutPanel aboutPanel = new AboutPanel();
        final JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Manual", manualPanel);
        tabbedPane.addTab("Automated", automatedPanel);
        tabbedPane.addTab("Log", loggerPanel);
        tabbedPane.addTab("Config", configPanel);
        tabbedPane.addTab("Terms", termsPanel);
        tabbedPane.addTab("Scripts", scriptsPanel);
        tabbedPane.addTab("Guild", guildPanel);
        tabbedPane.addTab("About/Help", aboutPanel);
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component tab = tabbedPane.getSelectedComponent();
                if (tab instanceof ConfigPanel) {
                    ((ConfigPanel)tab).tabSelected();
                }
            }
        });
        this.setContentPane(tabbedPane);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screenSize.width - 50, screenSize.height - 50);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                QicFrame.this.logger.info("windowClosing: now saving file changes");
                manualPanel.saveToFile();
                automatedPanel.saveToFile();
                termsPanel.saveCurrentScriptToFile();
                scriptsPanel.saveCurrentScriptToFile();
                configPanel.saveAndReloadConfig();
            }
        });
        manualPanel.initSplitPaneDivider();
        automatedPanel.initSplitPaneDivider();
    }
}

