/*
 * Decompiled with CFR 0.152.
 */
package qic.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qic.Command;
import qic.Main;
import qic.SearchPageScraper;
import qic.ui.SearchResultTable;
import qic.ui.extra.Worker;
import qic.util.Config;
import qic.util.DurianUtils;
import qic.util.SwingUtil;
import qic.util.Util;

public class ManualPanel
extends JPanel {
    private static final String MANUAL_TXT_FILENAME = "manual.txt";
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass().getName());
    private JList<String> searchJList = new JList();
    private DefaultListModel<String> searchJListModel = new DefaultListModel();
    private JSplitPane splitPane;
    private SearchResultTable table = new SearchResultTable();

    public ManualPanel(Main main) {
        super(new BorderLayout(5, 5));
        this.table.setDoubleBuffered(true);
        final JTextField searchTf = new JTextField(100);
        final JButton runBtn = new JButton("Run");
        runBtn.setPreferredSize(new Dimension(200, 10));
        JLabel invalidTermsLblLbl = new JLabel();
        invalidTermsLblLbl.setFont(invalidTermsLblLbl.getFont().deriveFont(1));
        JLabel invalidTermsLbl = new JLabel();
        invalidTermsLbl.setForeground(Color.RED);
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 0));
        JLabel searchLbl = new JLabel(" Search: ");
        searchLbl.setFont(searchLbl.getFont().deriveFont(1));
        northPanel.add(searchLbl);
        northPanel.add(searchTf);
        northPanel.add(invalidTermsLblLbl);
        northPanel.add(invalidTermsLbl);
        northPanel.add(runBtn);
        this.add((Component)northPanel, "North");
        List<String> searchList = Util.loadSearchList(MANUAL_TXT_FILENAME);
        searchList.stream().forEach(this.searchJListModel::addElement);
        this.searchJList.setModel(this.searchJListModel);
        this.searchJList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                searchTf.setText(StringUtils.trimToEmpty(this.searchJList.getSelectedValue()));
            }
        });
        this.searchJList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                int index;
                if (evt.getClickCount() == 2 && (index = ManualPanel.this.searchJList.locationToIndex(evt.getPoint())) != -1) {
                    String search = StringUtils.trimToEmpty((String)ManualPanel.this.searchJListModel.getElementAt(index));
                    searchTf.setText(search);
                    runBtn.doClick();
                }
            }
        });
        this.searchJList.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "doSomething");
        this.searchJList.getActionMap().put("doSomething", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = ManualPanel.this.searchJList.getSelectedIndex();
                if (selectedIndex != -1) {
                    ManualPanel.this.searchJListModel.remove(selectedIndex);
                }
            }
        });
        ActionListener runCommand = e -> {
            String tfText = searchTf.getText().trim();
            if (!tfText.isEmpty()) {
                Worker<Command> worker = new Worker<Command>(() -> {
                    runBtn.setEnabled(false);
                    Command result = null;
                    try {
                        result = this.runQuery(main, tfText);
                    }
                    catch (Exception ex) {
                        runBtn.setEnabled(true);
                        SwingUtil.showError(ex);
                    }
                    return result;
                }, command -> {
                    if (command != null) {
                        if (command.invalidSearchTerms.isEmpty()) {
                            this.addDataToTable((Command)command);
                            this.saveSearchToList(tfText);
                            invalidTermsLbl.setText("");
                            invalidTermsLblLbl.setText("");
                            if (Config.getBooleanProperty("manual.auto.verify", false)) {
                                long sleep = Config.getLongProperty("manual.auto.verify.wait.millisec", 5000L);
                                this.table.runAutoVerify(sleep);
                            }
                        } else {
                            String invalidTermsStr = command.invalidSearchTerms.stream().collect(Collectors.joining(", "));
                            invalidTermsLbl.setText(invalidTermsStr + " ");
                            invalidTermsLblLbl.setText(" Invalid: ");
                        }
                    }
                    runBtn.setEnabled(true);
                });
                worker.execute();
            }
        };
        searchTf.addActionListener(runCommand);
        runBtn.addActionListener(runCommand);
        this.splitPane = new JSplitPane(1, new JScrollPane(this.table), new JScrollPane(this.searchJList));
        this.add((Component)this.splitPane, "Center");
    }

    private void addDataToTable(Command command) {
        List<SearchPageScraper.SearchResultItem> itemResults = this.filterResults(command.itemResults);
        this.table.clear();
        this.table.addData(itemResults);
        this.table.updateData(0);
    }

    private List<SearchPageScraper.SearchResultItem> filterResults(List<SearchPageScraper.SearchResultItem> itemResults) {
        itemResults = itemResults.stream().filter(item -> DurianUtils.notBlacklisted("manual.search.blacklist", item)).collect(Collectors.toList());
        return itemResults;
    }

    public void initSplitPaneDivider() {
        this.splitPane.setResizeWeight(0.85);
        this.splitPane.setDividerLocation(0.85);
    }

    private void saveSearchToList(String tfText) {
        for (int i = 0; i < this.searchJListModel.size(); ++i) {
            String s = this.searchJListModel.getElementAt(i);
            if (!s.equalsIgnoreCase(tfText)) continue;
            return;
        }
        this.searchJListModel.addElement(tfText);
    }

    private Command runQuery(Main main, String tfText) throws Exception {
        String line = null;
        if (StringUtils.startsWithIgnoreCase(tfText, "sort")) {
            line = tfText;
        } else {
            String prefix = Config.getPropety("manual.search.prefix", "tmpsc online bo").trim();
            line = String.format("s %s %s", prefix, tfText);
        }
        this.logger.info("Now running search: " + line);
        return main.processLine(line);
    }

    public void saveToFile() {
        StringBuilder contents = new StringBuilder("");
        for (int i = 0; i < this.searchJListModel.size(); ++i) {
            String s = this.searchJListModel.getElementAt(i);
            contents.append(s);
            contents.append(System.lineSeparator());
        }
        try {
            Util.overwriteFile(MANUAL_TXT_FILENAME, contents.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

