/*
 * Decompiled with CFR 0.152.
 */
package qic.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qic.ui.extra.Worker;
import qic.util.Config;
import qic.util.GuildPageScraper;
import qic.util.SwingUtil;
import qic.util.Util;

public class GuildPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass().getName());
    JTextArea textArea = new JTextArea();

    public GuildPanel() {
        super(new BorderLayout(1, 1));
        this.textArea.setFont(new Font("Consolas", 0, 12));
        this.add((Component)new JScrollPane(this.textArea), "Center");
        JPanel southPanel = new JPanel();
        JButton guildBtn = new JButton("Append with Guildmates");
        JButton saveBtn = new JButton("Save");
        JTextField guildUrl = new JTextField(50);
        southPanel.add(new JLabel("Guild Profile No./Url"));
        southPanel.add(guildUrl);
        southPanel.add(guildBtn);
        southPanel.add(new JLabel("Discount: " + Config.getPropety("guild.discount.string", "1ch")));
        this.add((Component)southPanel, "South");
        southPanel.add(saveBtn);
        this.loadConfigToTextArea();
        guildBtn.addActionListener(e -> {
            String url = guildUrl.getText();
            if (!url.isEmpty()) {
                Worker<List> worker = new Worker<List>(() -> {
                    List<Object> members = Collections.emptyList();
                    String urlFinal = StringUtils.isNumeric(url) ? "https://www.pathofexile.com/guild/profile/" + url : url;
                    try {
                        members = GuildPageScraper.scrapeMembers(urlFinal);
                    }
                    catch (Exception ex) {
                        this.logger.error("Error while scraping guild page: " + urlFinal);
                        SwingUtil.showError(ex);
                    }
                    return members;
                }, guildNames -> {
                    if (!guildNames.isEmpty()) {
                        guildNames.stream().forEach(name -> {
                            String ls = this.textArea.getText().isEmpty() ? "" : System.lineSeparator();
                            this.textArea.append(ls + name);
                        });
                    }
                });
                worker.execute();
            }
        });
        saveBtn.addActionListener(e -> this.save());
    }

    void save() {
        try {
            Document document = this.textArea.getDocument();
            String content = document.getText(0, document.getLength());
            Util.overwriteFile("guild.txt", content);
        }
        catch (IOException | BadLocationException e) {
            this.logger.error("Error while saving to guild.txt");
            SwingUtil.showError(e);
        }
    }

    private void loadConfigToTextArea() {
        try {
            String str = FileUtils.readFileToString(new File("guild.txt"));
            this.textArea.setText(str);
            this.textArea.setCaretPosition(0);
        }
        catch (IOException e) {
            this.logger.error("Error while reading guild.txt");
            SwingUtil.showError(e);
        }
    }

    public void tabSelected() {
        this.textArea.requestFocusInWindow();
    }
}

