/*
 * Decompiled with CFR 0.152.
 */
package qic.ui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.commons.io.FileUtils;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qic.Main;
import qic.util.Config;
import qic.util.SwingUtil;
import qic.util.Util;

public class ConfigPanel
extends RTextScrollPane {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass().getName());
    RSyntaxTextArea textArea = new RSyntaxTextArea();

    public ConfigPanel() {
        this.textArea.setSyntaxEditingStyle("text/properties");
        this.setViewportView(this.textArea);
        this.loadConfigToTextArea();
        this.textArea.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ConfigPanel.this.saveAndReloadConfig();
                Main.reloadLookAndFeel();
            }

            @Override
            public void focusGained(FocusEvent e) {
                ConfigPanel.this.loadConfigToTextArea();
            }
        });
    }

    void saveAndReloadConfig() {
        try {
            Document document = this.textArea.getDocument();
            String content = document.getText(0, document.getLength());
            Util.overwriteFile("config.properties", content);
            Config.loadConfig();
        }
        catch (IOException | BadLocationException e) {
            this.logger.error("Error while saving to config.properties");
            SwingUtil.showError(e);
        }
    }

    private void loadConfigToTextArea() {
        try {
            String str = FileUtils.readFileToString(new File("config.properties"));
            this.textArea.setText(str);
            this.textArea.setCaretPosition(0);
        }
        catch (IOException e) {
            this.logger.error("Error while reading config.properties");
            SwingUtil.showError(e);
        }
    }

    public void tabSelected() {
        this.textArea.requestFocusInWindow();
    }
}

