/*
 * Decompiled with CFR 0.152.
 */
package qic.ui;

import com.porty.swing.table.model.BeanPropertyTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qic.Command;
import qic.Main;
import qic.SearchPageScraper;
import qic.ui.SearchResultTable;
import qic.ui.extra.CaptchaDetectedException;
import qic.util.Config;
import qic.util.DurianUtils;
import qic.util.SoundUtilsFX;
import qic.util.SwingUtil;
import qic.util.Util;
import qic.util.Verify;

public class AutomatedPanel
extends JPanel {
    private static final String AUTOMATED_TXT_FILENAME = "automated.txt";
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass().getName());
    JLabel statusLbl = new JLabel("Waiting for (0) seconds..");
    JButton runBtn = new JButton("Force");
    private Main main;
    private JTextArea searchListTa = new JTextArea(10, 15);
    private SearchResultTable table = new SearchResultTable();
    private static int countdown = 0;
    private ActionListener runCommand = e -> new QueryTask(this).execute();
    private Timer timer = new Timer(0, this.runCommand);
    private JSplitPane splitPane;

    public AutomatedPanel(Main main) {
        super(new BorderLayout(5, 5));
        this.main = main;
        this.table.setDoubleBuffered(true);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        controlPanel.add(this.runBtn);
        controlPanel.add(this.statusLbl);
        List<String> searchList = Util.loadSearchList(AUTOMATED_TXT_FILENAME);
        this.searchListTa.setFont(new Font("Consolas", 0, 12));
        this.searchListTa.setText(searchList.stream().collect(Collectors.joining(System.lineSeparator())));
        this.runBtn.addActionListener(e -> {
            countdown = 0;
            this.timer.restart();
        });
        JPanel eastPanel = new JPanel(new BorderLayout(5, 5));
        eastPanel.add((Component)controlPanel, "North");
        eastPanel.add((Component)new JScrollPane(this.searchListTa), "Center");
        this.splitPane = new JSplitPane(1, new JScrollPane(this.table), eastPanel);
        this.add((Component)this.splitPane, "Center");
        if (Config.getBooleanProperty("automated.search.enabled", false)) {
            this.timer.setDelay(1000);
            this.logger.info("Starting timer...");
            this.timer.restart();
        } else {
            this.runBtn.setEnabled(false);
        }
    }

    public void initSplitPaneDivider() {
        this.splitPane.setResizeWeight(0.85);
        this.splitPane.setDividerLocation(0.85);
    }

    public void saveToFile() {
        try {
            Util.overwriteFile(AUTOMATED_TXT_FILENAME, this.searchListTa.getText());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void playsound() {
        String pathToFile = Config.getPropety("automated.search.sound.filename", "notification.wav");
        double vol = Config.getDoubleProperty("automated.search.sound.volume", 1.0);
        new Thread(() -> SoundUtilsFX.play(pathToFile, vol)).run();
    }

    private static class QueryTask
    extends SwingWorker<Void, SearchPageScraper.SearchResultItem> {
        private final Logger logger = LoggerFactory.getLogger(this.getClass().getName());
        AutomatedPanel panel;
        int waitMins = Integer.parseInt(Config.getPropety("automated.search.wait.minutes", "15"));
        int waitSeconds = this.waitMins * 60;
        int waitSecondsInBetween = Integer.parseInt(Config.getPropety("automated.search.inbetween.wait.seconds", "15"));

        public QueryTask(AutomatedPanel panel) {
            this.panel = panel;
        }

        @Override
        protected Void doInBackground() {
            this.panel.statusLbl.setText("Waiting for (" + countdown + ") seconds..");
            if (countdown == 0) {
                countdown = this.waitSeconds;
                try {
                    this.runJob();
                }
                catch (Exception e) {
                    SwingUtil.showError(e);
                }
                finally {
                    this.panel.runBtn.setEnabled(true);
                }
            } else {
                countdown--;
            }
            return null;
        }

        private void runJob() throws CaptchaDetectedException {
            String text = this.panel.searchListTa.getText();
            if (!text.isEmpty()) {
                this.panel.runBtn.setEnabled(false);
                List previousData = this.getTableModel().getData().stream().map(SearchPageScraper.SearchResultItem::toUUID).collect(Collectors.toList());
                this.panel.table.clear();
                Object[] searches = text.split("\n");
                this.logger.info("searches: " + Arrays.toString(searches));
                int idx = 0;
                int total = 0;
                while (!this.isCancelled() && idx < searches.length) {
                    String prefix = Config.getPropety("automated.search.prefix", "tmpsc online bo").trim();
                    String search = ((String)searches[idx]).trim();
                    String line = String.format("s %s %s", prefix, search);
                    this.logger.info("Now running search: " + line);
                    Command command = this.runQuery(line);
                    ++idx;
                    List<SearchPageScraper.SearchResultItem> itemResults = command.itemResults;
                    itemResults = itemResults.stream().filter(item -> DurianUtils.notBlacklisted("automated.search.blacklist", item)).collect(Collectors.toList());
                    itemResults.stream().forEach(xva$0 -> this.publish(xva$0));
                    int count = 0;
                    if (Config.getBooleanProperty("automated.auto.verify", false)) {
                        long sleep = Config.getLongProperty("automated.auto.verify.wait.millisec", 3000L);
                        count += this.runVerify(itemResults, sleep);
                    } else {
                        count += itemResults.size();
                    }
                    if (count > 0 && Config.getBooleanProperty("automated.search.notify.newonly", true)) {
                        this.logger.info("Now checking if there are actually new items..");
                        List<SearchPageScraper.SearchResultItem> newItems = itemResults.stream().filter(item -> !previousData.contains(item.toUUID())).collect(Collectors.toList());
                        newItems.forEach(item -> {
                            item.newInAutomated = true;
                        });
                        if (newItems.isEmpty()) {
                            count = 0;
                        }
                    }
                    if (Config.getSoundMode() == Config.SoundMode.EACH_SEARCH && count > 0) {
                        this.panel.playsound();
                    }
                    total += count;
                    if (idx >= searches.length) continue;
                    this.logger.info(String.format("Automated Search - now sleep for %d seconds", this.waitSecondsInBetween));
                    Util.sleep(this.waitSecondsInBetween * 1000);
                }
                if (Config.getSoundMode() == Config.SoundMode.ONCE && total > 0) {
                    this.panel.playsound();
                }
            }
        }

        @Override
        protected void process(List<SearchPageScraper.SearchResultItem> itemResults) {
            this.panel.table.addData(itemResults);
            this.panel.table.updateData(0);
        }

        private Command runQuery(String line) throws CaptchaDetectedException {
            int count = 0;
            int maxTries = 10;
            while (true) {
                try {
                    return this.panel.main.processLine(line);
                }
                catch (CaptchaDetectedException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (++count != maxTries) continue;
                    throw new RuntimeException(e);
                }
                break;
            }
        }

        private int runVerify(List<SearchPageScraper.SearchResultItem> itemResults, long sleep) {
            int sum = 0;
            for (int i = 0; i < itemResults.size(); ++i) {
                SearchPageScraper.SearchResultItem item = itemResults.get(i);
                this.logger.info(String.format("Verifying item %s", item.toShortDebugInfo()));
                Verify verified = DurianUtils.verify(item.thread(), item.dataHash());
                item.verified(verified);
                this.logger.info(String.format("Verify result for item %s: %s", new Object[]{item.toShortDebugInfo(), verified}));
                BeanPropertyTableModel<SearchPageScraper.SearchResultItem> model = this.getTableModel();
                int index = model.getData().indexOf(item);
                this.panel.table.updateData(index);
                if (i < itemResults.size() - 1) {
                    this.logger.info(String.format("Verify - now sleeping for %s millisec", sleep));
                    Util.sleep(sleep);
                }
                int result = verified == Verify.VERIFIED ? 1 : 0;
                sum += result;
            }
            return sum;
        }

        private BeanPropertyTableModel<SearchPageScraper.SearchResultItem> getTableModel() {
            return (BeanPropertyTableModel)this.panel.table.getModel();
        }
    }
}

