/*
 * Decompiled with CFR 0.152.
 */
package qic;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qic.util.Config;
import qic.util.ImageCache;
import qic.util.Util;
import qic.util.Verify;

public class SearchPageScraper {
    private static final String regex_horizontal_whitespace = "(^\\h*)|(\\h*$)";
    private String page;

    public SearchPageScraper(String page) {
        this.page = page;
    }

    public List<SearchResultItem> parse() {
        LinkedList<SearchResultItem> searchResultItems = new LinkedList<SearchResultItem>();
        Document doc = Jsoup.parse(this.page, "UTF-8");
        Element content = doc.getElementById("content");
        Elements items = null;
        items = content == null ? doc.getElementsByClass("item") : content.getElementsByClass("item");
        for (Element element : items) {
            Element itemMods;
            SearchResultItem item = new SearchResultItem();
            item.id = element.attr("id");
            item.id = StringUtils.remove(item.id, "item-container-");
            item.seller = element.attr("data-seller");
            item.thread = element.attr("data-thread");
            item.sellerid = element.attr("data-sellerid");
            item.buyout = element.attr("data-buyout");
            item.ign = element.attr("data-ign");
            item.league = element.attr("data-league");
            item.name = element.attr("data-name");
            item.corrupted = element.getElementsByClass("corrupted").size() > 0;
            item.identified = element.getElementsByClass("item-unid").size() == 0;
            Element sockElem = (Element)element.getElementsByClass("sockets-raw").get(0);
            item.socketsRaw = sockElem.text();
            Elements accntAgeElement = element.getElementsByAttributeValue("title", "account age and highest level");
            if (accntAgeElement != null && !accntAgeElement.isEmpty()) {
                item.ageAndHighLvl = ((Element)accntAgeElement.get(0)).text();
            }
            Element reqElem = (Element)element.getElementsByClass("requirements").get(0);
            List<TextNode> reqNodes = reqElem.textNodes();
            for (TextNode reqNode : reqNodes) {
                String reqType;
                String req = StringUtils.trimToEmpty(reqNode.getWholeText());
                req = req.replaceAll(regex_horizontal_whitespace, "");
                req = Util.removeThoseDamnWhiteSpace(req);
                String separator = ":";
                switch (reqType = StringUtils.trim(StringUtils.substringBefore(req, separator))) {
                    case "Level": {
                        item.reqLvl = StringUtils.trim(StringUtils.substringAfter(req, separator));
                        break;
                    }
                    case "Strength": {
                        item.reqStr = StringUtils.trim(StringUtils.substringAfter(req, separator));
                        break;
                    }
                    case "Intelligence": {
                        item.reqInt = StringUtils.trim(StringUtils.substringAfter(req, separator));
                        break;
                    }
                    case "Dexterity": {
                        item.reqDex = StringUtils.trim(StringUtils.substringAfter(req, separator));
                    }
                }
            }
            item.mapQuantity = element.getElementsByAttributeValue("data-name", "mapq").stream().findFirst().map(n -> n.text()).map(s -> StringUtils.substringAfter(s, "Item quantity:")).map(s -> StringUtils.removePattern(s, "[^\\d]")).orElse("").replaceAll(regex_horizontal_whitespace, "").trim();
            String itemframeStr = element.getElementsByClass("title").stream().findFirst().map(n -> n.attr("class")).orElse(null);
            if ((itemframeStr = Util.regexMatch("itemframe(\\d)", itemframeStr, 1)) != null) {
                int frame = Integer.parseInt(itemframeStr);
                item.rarity = SearchResultItem.Rarity.valueOf(frame);
            } else {
                item.rarity = SearchResultItem.Rarity.unknown;
            }
            item.dataHash = element.getElementsByAttributeValue("onclick", "verify_modern(this)").stream().findFirst().map(n -> n.attr("data-hash")).orElse("").trim();
            Elements itemModsElements = element.getElementsByClass("item-mods");
            if (itemModsElements != null && itemModsElements.size() > 0 && (itemMods = (Element)itemModsElements.get(0)).getElementsByClass("bullet-item").size() != 0) {
                Element bulletItem = (Element)itemMods.getElementsByClass("bullet-item").get(0);
                Elements ulMods = bulletItem.getElementsByTag("ul");
                if (ulMods.size() == 2) {
                    SearchResultItem.Mod impMod;
                    Elements implicitLIs = ((Element)ulMods.get(0)).getElementsByTag("li");
                    Element implicitLi = implicitLIs.last();
                    item.implicitMod = impMod = new SearchResultItem.Mod(implicitLi.attr("data-name"), implicitLi.attr("data-value"));
                }
                int indexOfExplicitMods = ulMods.size() - 1;
                Elements modsLi = ((Element)ulMods.get(indexOfExplicitMods)).getElementsByTag("li");
                for (Element modLi : modsLi) {
                    SearchResultItem.Mod mod = new SearchResultItem.Mod(modLi.attr("data-name"), modLi.attr("data-value"));
                    item.explicitMods.add(mod);
                }
            }
            item.quality = ((Element)element.getElementsByAttributeValue("data-name", "q").get(0)).text().replaceAll(regex_horizontal_whitespace, "").trim();
            item.physDmgRangeAtMaxQuality = ((Element)element.getElementsByAttributeValue("data-name", "quality_pd").get(0)).text().replaceAll(regex_horizontal_whitespace, "").trim();
            item.eleDmgRange = ((Element)element.getElementsByAttributeValue("data-name", "ed").get(0)).text().replaceAll(regex_horizontal_whitespace, "").trim();
            item.attackSpeed = ((Element)element.getElementsByAttributeValue("data-name", "aps").get(0)).text().replaceAll(regex_horizontal_whitespace, "").trim();
            item.dmgAtMaxQuality = ((Element)element.getElementsByAttributeValue("data-name", "quality_dps").get(0)).text().replaceAll(regex_horizontal_whitespace, "").trim();
            item.physDmgAtMaxQuality = ((Element)element.getElementsByAttributeValue("data-name", "quality_pdps").get(0)).text().replaceAll(regex_horizontal_whitespace, "").trim();
            item.eleDmg = ((Element)element.getElementsByAttributeValue("data-name", "edps").get(0)).text().replaceAll(regex_horizontal_whitespace, "").trim();
            item.armourAtMaxQuality = ((Element)element.getElementsByAttributeValue("data-name", "quality_armour").get(0)).text().replaceAll(regex_horizontal_whitespace, "").trim();
            item.evasionAtMaxQuality = ((Element)element.getElementsByAttributeValue("data-name", "quality_evasion").get(0)).text().replaceAll(regex_horizontal_whitespace, "").trim();
            item.energyShieldAtMaxQuality = ((Element)element.getElementsByAttributeValue("data-name", "quality_shield").get(0)).text().replaceAll(regex_horizontal_whitespace, "").trim();
            item.block = ((Element)element.getElementsByAttributeValue("data-name", "block").get(0)).text().replaceAll(regex_horizontal_whitespace, "").trim();
            item.crit = ((Element)element.getElementsByAttributeValue("data-name", "crit").get(0)).text().replaceAll(regex_horizontal_whitespace, "").trim();
            item.level = ((Element)element.getElementsByAttributeValue("data-name", "level").get(0)).text().replaceAll(regex_horizontal_whitespace, "").trim();
            item.imageUrl = ((Element)element.getElementsByAttributeValue("alt", "Item icon").get(0)).attr("src");
            item.stackSize = Arrays.asList(StringUtils.split(StringUtils.trimToEmpty(item.imageUrl), '&')).stream().filter(t -> t.startsWith("stackSize=")).findFirst().map(s -> StringUtils.substringAfter(s, "=")).orElse(null);
            Elements onlineSpans = element.getElementsMatchingText("online");
            item.online = !onlineSpans.isEmpty() ? "Online" : "";
            searchResultItems.add(item);
        }
        return searchResultItems;
    }

    public static class SearchResultItem {
        private final Logger logger = LoggerFactory.getLogger(this.getClass().getName());
        public String id;
        public String buyout;
        public String name;
        public String ign;
        public boolean corrupted;
        public boolean identified;
        public Rarity rarity;
        public String dataHash;
        public String socketsRaw;
        public String stackSize;
        public String quality;
        public String physDmgRangeAtMaxQuality;
        public String physDmgAtMaxQuality;
        public String eleDmgRange;
        public String attackSpeed;
        public String dmgAtMaxQuality;
        public String crit;
        public String level;
        public String eleDmg;
        public String armourAtMaxQuality;
        public String evasionAtMaxQuality;
        public String energyShieldAtMaxQuality;
        public String block;
        public String reqLvl;
        public String reqStr;
        public String reqInt;
        public String reqDex;
        public String mapQuantity;
        public String ageAndHighLvl;
        public String league;
        public String seller;
        public String thread;
        public String sellerid;
        public String threadUrl;
        public String online;
        public String imageUrl;
        public Mod implicitMod;
        public List<Mod> explicitMods = new ArrayList<Mod>();
        public Verify verified = Verify.UKNOWN;
        public boolean guildItem = false;
        public String wtb = null;
        public String guildDiscount = null;
        public boolean newInAutomated = false;

        public List<Mod> getMods() {
            List<Mod> mods = this.explicitMods.stream().collect(Collectors.toList());
            if (this.implicitMod != null) {
                mods.add(0, new Mod("--------------", null));
                mods.add(0, this.implicitMod);
            }
            return mods;
        }

        public List<String> getReqs() {
            return this.labelList(this.labelVal("Lvl", this.reqLvl), this.labelVal("Str", this.reqStr), this.labelVal("Dex", this.reqDex), this.labelVal("Int", this.reqInt));
        }

        public List<String> getItem() {
            return this.labelList(this.labelVal("No", this.idFinal()), this.labelVal("Name", this.nameFinal()), this.labelVal("League", this.league), this.labelVal("Quality", this.quality), this.labelVal("Identified", String.valueOf(this.identified)), this.labelVal("Corrupted", String.valueOf(this.corrupted)), this.labelVal("SocketsRaw", this.socketsRaw), this.labelVal("StackSize", this.stackSize), this.labelVal("MapQuantity", this.mapQuantity));
        }

        public List<String> getOffense() {
            return this.labelList(this.labelVal("pDPS", this.physDmgAtMaxQuality), this.labelVal("eDPS", this.eleDmg), this.labelVal("DPS", this.dmgAtMaxQuality), this.labelVal("APS", this.attackSpeed), this.labelVal("ele", this.eleDmgRange), this.labelVal("phys", this.physDmgRangeAtMaxQuality));
        }

        public List<String> getDefense() {
            return this.labelList(this.labelVal("Armour", this.armourAtMaxQuality), this.labelVal("Evasion", this.evasionAtMaxQuality), this.labelVal("ES", this.energyShieldAtMaxQuality), this.labelVal("Block", this.block), this.labelVal("Crit", this.crit), this.labelVal("Map-Gem Lvl", this.level));
        }

        private List<String> labelList(String ... labels) {
            return Arrays.asList(labels).stream().filter(Objects::nonNull).collect(Collectors.toList());
        }

        public List<String> getSeller() {
            String highestLvl = StringUtils.substringAfter(this.ageAndHighLvl, "h");
            String age = StringUtils.substringBetween(this.ageAndHighLvl, "a", "h");
            age = StringUtils.isNumeric(age) ? LocalDate.now().minusDays(Integer.parseInt(age)).format(DateTimeFormatter.ofPattern("MMM dd uuuu")) : age;
            return this.labelList(this.labelVal("IGN", this.ign), this.labelVal("Joined", age), this.labelVal("HighestLvl", highestLvl), this.labelVal("Account", this.seller), this.labelVal("Thread", this.thread), this.labelVal("Verified", this.verified.name()), this.labelVal("Online", String.valueOf(StringUtils.containsIgnoreCase(this.online, "online"))));
        }

        private String labelVal(String label, String val) {
            return StringUtils.trimToNull(val) == null ? null : label + ": " + val;
        }

        public String wtb() {
            if (this.wtb != null) {
                return this.wtb;
            }
            return String.format("@%s Hi, WTB your \"%s\" listed for %s in %s league.", this.ign, this.name, this.buyout, this.league);
        }

        public void wtb(String wtb) {
            this.wtb = wtb;
        }

        public void guildDiscount(String guildDiscount) {
            this.guildDiscount = guildDiscount;
        }

        public String guildDiscount() {
            return this.guildDiscount;
        }

        public boolean newInAutomated() {
            return this.newInAutomated;
        }

        public String toDisplay(String newLine) {
            StringBuilder builder = new StringBuilder();
            String _quality = StringUtils.isNotBlank(this.quality) ? " " + this.quality + "%" : "";
            String linksocks = StringUtils.isNotBlank(this.socketsRaw) ? " " + this.socketsRaw : "";
            String strCorrupt = this.corrupted ? " Corrupted " : "";
            strCorrupt = strCorrupt + (!this.identified ? " Unidentified " : "");
            builder.append(String.format("[%s] %s%s%s", this.id, this.name, linksocks, _quality));
            builder.append(String.format("%s -----%s------ ", newLine, strCorrupt));
            builder.append(newLine);
            if (this.implicitMod != null) {
                builder.append(String.format("%s", this.implicitMod.toStringDisplay()));
                builder.append(newLine + " ----------- " + newLine);
            }
            if (this.explicitMods.size() > 0) {
                for (Mod mod : this.explicitMods) {
                    builder.append(String.format("%s", mod.toStringDisplay()));
                    builder.append(newLine);
                }
                builder.append("-----------" + newLine);
            }
            String _physDmg = StringUtils.isNotBlank(this.physDmgAtMaxQuality) ? "pDPS " + this.physDmgAtMaxQuality : "";
            String _eleDmg = StringUtils.isNotBlank(this.eleDmg) ? "eDPS " + this.eleDmg : "";
            String _attackSpeed = StringUtils.isNotBlank(this.attackSpeed) ? "APS " + this.attackSpeed : "";
            String _crit = StringUtils.isNotBlank(this.crit) ? "Cc " + this.crit : "";
            String offense = String.format("%s %s %s %s", _physDmg, _eleDmg, _attackSpeed, _crit).trim();
            offense = offense.isEmpty() ? "" : offense + newLine;
            builder.append(offense);
            String _armour = StringUtils.isNotBlank(this.armourAtMaxQuality) ? "Ar " + this.armourAtMaxQuality : "";
            String _evasion = StringUtils.isNotBlank(this.evasionAtMaxQuality) ? "Ev " + this.evasionAtMaxQuality : "";
            String _energyShield = StringUtils.isNotBlank(this.energyShieldAtMaxQuality) ? "Es " + this.energyShieldAtMaxQuality : "";
            String _block = StringUtils.isNotBlank(this.block) ? "Bk " + this.block : "";
            String defense = String.format("%s %s %s %s", _armour, _evasion, _energyShield, _block).trim();
            defense = defense.isEmpty() ? "" : defense + newLine;
            builder.append(defense);
            builder.append(String.format("%s IGN: %s", this.buyout, this.ign));
            return builder.toString();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            String lineSeparator = System.lineSeparator();
            builder.append(lineSeparator);
            builder.append("id=");
            builder.append(this.id);
            builder.append(lineSeparator);
            builder.append("buyout=");
            builder.append(this.buyout);
            builder.append(lineSeparator);
            builder.append("name=");
            builder.append(this.name);
            builder.append(lineSeparator);
            builder.append("corrupted=");
            builder.append(this.corrupted);
            builder.append(lineSeparator);
            builder.append("identified=");
            builder.append(this.identified);
            builder.append(lineSeparator);
            builder.append("ign=");
            builder.append(this.ign);
            builder.append(lineSeparator);
            builder.append("socketsRaw=");
            builder.append(this.socketsRaw);
            builder.append(lineSeparator);
            builder.append("stackSize=");
            builder.append(this.stackSize);
            builder.append(lineSeparator);
            builder.append("quality=");
            builder.append(this.quality);
            builder.append(lineSeparator);
            builder.append("physDmgRangeAtMaxQuality=");
            builder.append(this.physDmgRangeAtMaxQuality);
            builder.append(lineSeparator);
            builder.append("physDmgAtMaxQuality=");
            builder.append(this.physDmgAtMaxQuality);
            builder.append(lineSeparator);
            builder.append("eleDmgRange=");
            builder.append(this.eleDmgRange);
            builder.append(lineSeparator);
            builder.append("attackSpeed=");
            builder.append(this.attackSpeed);
            builder.append(lineSeparator);
            builder.append("dmgAtMaxQuality=");
            builder.append(this.dmgAtMaxQuality);
            builder.append(lineSeparator);
            builder.append("crit=");
            builder.append(this.crit);
            builder.append(lineSeparator);
            builder.append("level=");
            builder.append(this.level);
            builder.append(lineSeparator);
            builder.append("eleDmg=");
            builder.append(this.eleDmg);
            builder.append(lineSeparator);
            builder.append("armourAtMaxQuality=");
            builder.append(this.armourAtMaxQuality);
            builder.append(lineSeparator);
            builder.append("evasionAtMaxQuality=");
            builder.append(this.evasionAtMaxQuality);
            builder.append(lineSeparator);
            builder.append("energyShieldAtMaxQuality=");
            builder.append(this.energyShieldAtMaxQuality);
            builder.append(lineSeparator);
            builder.append("block=");
            builder.append(this.block);
            builder.append(lineSeparator);
            builder.append("reqLvl=");
            builder.append(this.reqLvl);
            builder.append(lineSeparator);
            builder.append("reqStr=");
            builder.append(this.reqStr);
            builder.append(lineSeparator);
            builder.append("reqInt=");
            builder.append(this.reqInt);
            builder.append(lineSeparator);
            builder.append("reqDex=");
            builder.append(this.reqDex);
            builder.append(lineSeparator);
            builder.append("mapQuantity=");
            builder.append(this.mapQuantity);
            builder.append(lineSeparator);
            builder.append("ageAndHighLvl=");
            builder.append(this.ageAndHighLvl);
            builder.append(lineSeparator);
            builder.append("league=");
            builder.append(this.league);
            builder.append(lineSeparator);
            builder.append("seller=");
            builder.append(this.seller);
            builder.append(lineSeparator);
            builder.append("thread=");
            builder.append(this.thread);
            builder.append(lineSeparator);
            builder.append("sellerid=");
            builder.append(this.sellerid);
            builder.append(lineSeparator);
            builder.append("threadUrl=");
            builder.append(this.threadUrl);
            builder.append(lineSeparator);
            builder.append("imageUrl=");
            builder.append(this.imageUrl);
            builder.append(lineSeparator);
            builder.append("implicitMod=");
            builder.append(this.implicitMod);
            builder.append(lineSeparator);
            builder.append("explicitMods=");
            builder.append(this.explicitMods);
            builder.append(lineSeparator);
            builder.append("online=");
            builder.append(this.online);
            builder.append(lineSeparator);
            return builder.toString();
        }

        public String getBo() {
            String str = this.buyout;
            str = StringUtils.replace(str, "alteration", "alt");
            str = StringUtils.replace(str, "fusing", "fuse");
            str = StringUtils.replace(str, "jewellers", "jew");
            str = StringUtils.replace(str, "exalted", "ex");
            str = StringUtils.replace(str, "alchemy", "alch");
            str = StringUtils.replace(str, "chaos", "ch");
            str = StringUtils.replace(str, "chromatic", "chrm");
            str = StringUtils.replace(str, "chance", "chan");
            return str;
        }

        public static SearchResultItem exceptionItem(Exception e) {
            SearchResultItem item = new SearchResultItem();
            item.name = e.getMessage();
            item.ign = e.getClass().getName();
            item.socketsRaw = e.getCause().getMessage();
            return item;
        }

        public String seller() {
            return this.seller;
        }

        public String dataHash() {
            return this.dataHash;
        }

        public String thread() {
            return this.thread;
        }

        public String toShortDebugInfo() {
            return String.format("id=%s name=%s account=%s thread=%s", this.id, this.name, this.seller, this.thread);
        }

        public void verified(Verify verified) {
            this.verified = verified;
        }

        public void guildItem(boolean guildItem) {
            this.guildItem = guildItem;
        }

        public String nameFinal() {
            return this.name;
        }

        public String idFinal() {
            if (this.corrupted) {
                return this.id + " [CORRUPTED]";
            }
            return this.id;
        }

        public ImageIcon getArt() {
            ImageIcon imageIcon = null;
            try {
                boolean artEnabled = Config.getBooleanProperty("result.table.art.enabled", true);
                if (artEnabled) {
                    URL url = new URL(this.imageUrl);
                    imageIcon = ImageCache.getInstance().get(url.toString());
                }
            }
            catch (MalformedURLException e) {
                this.logger.error("Error while grabbing art from: " + this.imageUrl, e);
            }
            return imageIcon;
        }

        public int toUUID() {
            String explicitModsUUID = this.explicitMods.stream().map(Mod::toUUID).collect(Collectors.joining(":"));
            String implicitModuuid = this.implicitMod != null ? this.implicitMod.toUUID() : null;
            List<String> uuidList = Arrays.asList(this.thread, this.name, this.buyout, String.valueOf(this.corrupted), this.socketsRaw, this.quality, this.physDmgRangeAtMaxQuality, this.physDmgAtMaxQuality, this.eleDmgRange, this.attackSpeed, this.dmgAtMaxQuality, this.crit, this.level, this.eleDmg, this.armourAtMaxQuality, this.evasionAtMaxQuality, this.energyShieldAtMaxQuality, this.block, this.mapQuantity, implicitModuuid, explicitModsUUID);
            String uuid = uuidList.stream().collect(Collectors.joining(":"));
            return uuid.hashCode();
        }

        public boolean guildItem() {
            return this.guildItem;
        }

        public static enum Rarity {
            normal,
            magic,
            rare,
            unique,
            gem,
            currency,
            divinationcard,
            unknown;


            public static Rarity valueOf(int ordinal) {
                for (Rarity r : Rarity.values()) {
                    if (r.ordinal() != ordinal) continue;
                    return r;
                }
                return unknown;
            }
        }

        public static class Mod {
            String name;
            String value;
            String forgottenMod;

            public Mod(String name, String value) {
                this.name = name;
                this.value = value;
            }

            public String getName() {
                return this.name;
            }

            public String getValue() {
                return this.value;
            }

            public String getForgottenMod() {
                return this.forgottenMod;
            }

            public void setForgottenMod(String forgottenMod) {
                this.forgottenMod = forgottenMod;
            }

            public String toString() {
                if (this.forgottenMod != null) {
                    return this.forgottenMod;
                }
                return this.toStringDisplay();
            }

            public String toStringDisplay() {
                String display = this.name;
                if (StringUtils.startsWith(this.name, "#") || StringUtils.startsWith(this.name, "$")) {
                    display = StringUtils.removeStart(display, "#");
                    display = StringUtils.removeStart(display, "$");
                    String val = StringUtils.endsWith(this.value, ".0") ? StringUtils.substringBefore(this.value, ".0") : this.value;
                    display = StringUtils.replaceOnce(display, "#", val);
                }
                return display;
            }

            public String toUUID() {
                return this.name + ":" + this.value;
            }
        }
    }
}

