/*
 * Decompiled with CFR 0.152.
 */
package qic;

import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qic.BackendClient;
import qic.BlackmarketLanguage;
import qic.Command;
import qic.SearchPageScraper;
import qic.ui.QicFrame;
import qic.util.CommandLine;
import qic.util.Config;
import qic.util.FmJS;
import qic.util.SessProp;
import qic.util.Util;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class.getName());
    BackendClient backendClient = new BackendClient();
    SessProp sessProp = new SessProp();
    Long searchDuration = null;
    List<String> invalidSearchTerms = null;

    public static void main(String[] args) throws Exception {
        try {
            Main.reloadConfig();
            new Main(args);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error occured: " + e.getMessage());
            throw e;
        }
    }

    public static void reloadConfig() throws Exception, FileNotFoundException {
        Config.loadConfig();
    }

    public static void reloadLookAndFeel() {
        if (Config.getBooleanProperty("lookandfeel.decorated.enabled", false)) {
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        try {
            String lookAndFeel = Config.getPropety("lookandfeel", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            if (lookAndFeel.startsWith("Substance")) {
                lookAndFeel = "org.pushingpixels.substance.api.skin." + lookAndFeel;
            }
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception e) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        for (Window window : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    public Main(String[] args) throws Exception {
        CommandLine cmd = new CommandLine(args);
        boolean guiEnabled = cmd.hasFlag("-gui");
        guiEnabled = guiEnabled || cmd.getNumberOfArguments() == 0;
        logger.info("guiEnabled: " + guiEnabled);
        if (guiEnabled) {
            this.showGui(cmd.getArgument(0));
        } else {
            if (cmd.getNumberOfArguments() == 0) {
                throw new IllegalArgumentException("First arguement needed, and should be the query. e.g. 'search chest 100life 6s5L'. Enclosed in double quoutes if needed.");
            }
            String query = cmd.getArgument(0);
            logger.info("Query: " + query);
            Command command = this.processLine(query);
            String json = command.toJson();
            this.writeToFile(json);
        }
    }

    private void showGui(String query) {
        Main.reloadLookAndFeel();
        SwingUtilities.invokeLater(() -> new QicFrame(this, query));
    }

    public void writeToFile(String contents) throws IOException {
        Util.overwriteFile("results.json", contents);
    }

    public Command processLine(String line) throws Exception {
        Command command = new Command(line);
        this.searchDuration = null;
        this.invalidSearchTerms = new LinkedList<String>();
        try {
            String terms;
            if (line.startsWith("sort") && !this.sessProp.getLocation().isEmpty()) {
                command.itemResults = this.runSearch(line, true);
                command.searchDuration = this.searchDuration;
            } else if (line.startsWith("s ") && !(terms = StringUtils.substringAfter(line, "s ").trim()).isEmpty()) {
                command.itemResults = this.runSearch(terms, false);
                command.searchDuration = this.searchDuration;
            }
            command.league = this.sessProp.getLeague();
            command.invalidSearchTerms = this.invalidSearchTerms;
            command.status = Command.Status.SUCCESS;
        }
        catch (Exception e) {
            e.printStackTrace();
            command.status = Command.Status.ERROR;
            command.errorMessage = e.getMessage();
            command.errorStackTrace = ExceptionUtils.getStackTrace(e);
            throw e;
        }
        this.setGuildInfo(command.itemResults);
        FmJS fmJS = new FmJS(command.itemResults);
        fmJS.process();
        return command;
    }

    private void setGuildInfo(List<SearchPageScraper.SearchResultItem> itemResults) throws IOException {
        String nameList = FileUtils.readFileToString(new File("guild.txt"));
        if (!nameList.isEmpty()) {
            List<String> names = Arrays.asList(StringUtils.split(nameList));
            itemResults.stream().forEach(item -> {
                boolean guildmate = names.stream().anyMatch(name -> StringUtils.equalsIgnoreCase(name, item.seller()));
                item.guildItem(guildmate);
                item.guildDiscount(Config.getPropety("guild.discount.string", "1ch"));
            });
        }
    }

    private List<SearchPageScraper.SearchResultItem> runSearch(String terms, boolean sortOnly) throws Exception {
        String html = this.downloadHtml(terms, sortOnly);
        if (html == null) {
            return Collections.emptyList();
        }
        SearchPageScraper scraper = new SearchPageScraper(html);
        List<SearchPageScraper.SearchResultItem> items = scraper.parse();
        logger.info("items found: " + items.size());
        return items;
    }

    public String downloadHtml(String terms, boolean sortOnly) throws Exception {
        long start = System.currentTimeMillis();
        String regex = "([^\\s]*=\".*?\")";
        List<String> customHttpKeyVals = Util.regexMatches(regex, terms, 1);
        String customHttpKeyVal = customHttpKeyVals.stream().map(s -> StringUtils.remove(s, '\"')).collect(Collectors.joining("&"));
        String query = terms.replaceAll(regex, " ");
        BlackmarketLanguage language = new BlackmarketLanguage();
        BlackmarketLanguage.ParseResult sortParseResult = language.parseSortToken(query);
        String sort = sortParseResult.result;
        sort = sort == null ? "price_in_chaos" : sort;
        this.invalidSearchTerms.addAll(sortParseResult.invalidSearchTerms);
        if (!sortOnly) {
            logger.info("Query: " + query);
            BlackmarketLanguage.ParseResult queryParseResult = language.parse(query);
            String payload = queryParseResult.result;
            this.invalidSearchTerms.addAll(queryParseResult.invalidSearchTerms);
            if (this.invalidSearchTerms.isEmpty()) {
                payload = Arrays.asList(payload, customHttpKeyVal, "capquality=x").stream().filter(StringUtils::isNotBlank).collect(Collectors.joining("&"));
                logger.info("Unencoded payload: " + payload);
                payload = Arrays.asList(payload.split("&")).stream().map(Util::encodeQueryParm).collect(Collectors.joining("&"));
                String location = this.submitSearchForm(payload);
                String league = language.parseLeagueToken(query);
                this.sessProp.setLocation(location);
                this.sessProp.setLeague(league);
                this.sessProp.saveToFile();
            }
        }
        String searchPage = null;
        if (this.invalidSearchTerms.isEmpty()) {
            logger.info("sort: " + sort);
            searchPage = this.ajaxSort(sort);
        } else {
            logger.info("invalidSearchTerms: " + this.invalidSearchTerms.toString());
        }
        long end = System.currentTimeMillis();
        long duration = end - start;
        logger.info("Took " + duration + " ms");
        this.searchDuration = duration;
        return searchPage;
    }

    private String ajaxSort(String sort) throws Exception {
        String searchPage = "";
        sort = URLEncoder.encode(sort, "UTF-8");
        sort = "sort=" + sort + "&bare=true";
        searchPage = this.backendClient.postXMLHttpRequest(this.sessProp.getLocation(), sort);
        return searchPage;
    }

    private String submitSearchForm(String payload) throws Exception {
        String url = "http://poe.trade/search";
        String location = this.backendClient.post(url, payload);
        return location;
    }
}

