/*
 * Decompiled with CFR 0.152.
 */
package qic;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class BlackmarketLanguage {
    Map<String, String> dictionary = new LinkedHashMap<String, String>();
    Map<String, Map<String, String>> dictionaries = new LinkedHashMap<String, Map<String, String>>();
    Map<String, String> macroMap = new HashMap<String, String>();

    public BlackmarketLanguage() throws IOException {
        File[] files;
        File terms = new File("terms");
        for (File file : files = terms.listFiles()) {
            if (file.isDirectory()) continue;
            List<String> lines = FileUtils.readLines(file);
            Map<String, String> map = lines.stream().filter(s -> StringUtils.isNotBlank(s) && !s.startsWith(";")).collect(Collectors.toMap(s -> StringUtils.substringBefore(s, "=").trim(), s -> StringUtils.substringAfter(s, "=").trim()));
            this.dictionary.putAll(map);
            this.dictionaries.put(file.getName(), map);
        }
        this.macroMap.put("$MG", "group_type=And&group_min=&group_max=&group_count=1");
    }

    public ParseResult parse(String input) {
        List<String> tokens = Arrays.asList(StringUtils.split(input));
        List<ParseTokenResult> translated = tokens.stream().filter(token -> !this.isSortToken((String)token)).map(this::processToken).collect(Collectors.toList());
        String finalResult = translated.stream().filter(p -> p.result != null).map(p -> p.result).collect(Collectors.joining("&"));
        return new ParseResult(finalResult, this.getInvalidTokens(translated));
    }

    public ParseResult parseSortToken(String input) throws IllegalArgumentException {
        ParseResult finalResult = new ParseResult("price_in_chaos", Collections.emptyList());
        List<String> tokens = Arrays.asList(StringUtils.split(input));
        List translated = tokens.stream().filter(token -> this.isSortToken((String)token)).map(this::processToken).collect(Collectors.toList());
        if (translated.size() > 1) {
            throw new IllegalArgumentException("More than 1 sort token detected. Only one is allowed.");
        }
        if (translated.size() == 1) {
            ParseTokenResult parseTokenResult = (ParseTokenResult)translated.get(0);
            finalResult = new ParseResult(parseTokenResult.result, this.getInvalidTokens(Arrays.asList(parseTokenResult)));
        }
        return finalResult;
    }

    private List<String> getInvalidTokens(List<ParseTokenResult> list) {
        return list.stream().filter(p -> p.result == null).map(p -> p.token).collect(Collectors.toList());
    }

    ParseTokenResult processToken(String token) {
        return this.processToken(token, this.dictionary);
    }

    ParseTokenResult processToken(String token, Map<String, String> dictionary) {
        String result = null;
        for (Map.Entry<String, String> entry : dictionary.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.equalsIgnoreCase(token)) {
                result = value;
                break;
            }
            Pattern pattern = Pattern.compile(key, 2);
            Matcher matcher = pattern.matcher(token);
            if (!matcher.matches()) continue;
            result = value;
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                String placeholder = "$GROUP" + i;
                if (!result.contains(placeholder)) continue;
                result = result.replace(placeholder, matcher.group(i));
            }
        }
        if (result != null) {
            for (Map.Entry<String, String> macroEntry : this.macroMap.entrySet()) {
                if (!result.contains(macroEntry.getKey())) continue;
                result = result.replace(macroEntry.getKey(), macroEntry.getValue());
            }
        }
        return new ParseTokenResult(token, result);
    }

    boolean isSortToken(String token) {
        return token.toLowerCase().startsWith("sort");
    }

    public String parseLeagueToken(String input) {
        String finalResult = "No league specified";
        List<String> tokens = Arrays.asList(StringUtils.split(input));
        Map<String, String> map = this.dictionaries.get("leagues.txt");
        List translated = tokens.stream().map(t -> this.processToken((String)t, map)).map(pr -> pr.result).filter(Objects::nonNull).collect(Collectors.toList());
        if (translated.size() > 1) {
            throw new IllegalArgumentException("More than 1 league token detected. Only one is allowed.");
        }
        if (translated.size() == 1) {
            finalResult = (String)translated.get(0);
            finalResult = StringUtils.substringAfter(finalResult, "=");
        }
        return finalResult;
    }

    public Map<String, String> getDictionary() {
        return this.dictionary;
    }

    public Map<String, Map<String, String>> getDictionaries() {
        return this.dictionaries;
    }

    private static class ParseTokenResult {
        String token;
        String result;

        public ParseTokenResult(String token, String result) {
            this.token = token;
            this.result = result;
        }
    }

    public static class ParseResult {
        String result;
        List<String> invalidSearchTerms = null;

        public ParseResult(String result, List<String> invalidSearchTerms) {
            this.result = result;
            this.invalidSearchTerms = invalidSearchTerms;
        }
    }
}

