/*
 * Decompiled with CFR 0.152.
 */
package qic;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.lang3.RandomUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qic.ui.extra.CaptchaDetectedException;

public class BackendClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass().getName());
    private HttpClient client = HttpClientBuilder.create().build();
    int timeout = 15;
    int CONNECTION_TIMEOUT = this.timeout * 1000;
    RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.CONNECTION_TIMEOUT).setConnectTimeout(this.CONNECTION_TIMEOUT).setSocketTimeout(this.CONNECTION_TIMEOUT).build();
    public final String userAgent = userAgents[RandomUtils.nextInt(0, userAgents.length)];
    public static final String USER_AGENT = "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:39.0) Gecko/20100101 Firefox/39.0";
    public static final String[] userAgents = new String[]{"Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US) AppleWebKit/525.13 (KHTML, like Gecko) Chrome/0.2.149.27 Safari/525.13", "Mozilla/5.0 (Windows; U; Windows NT 6.0; de) AppleWebKit/525.13 (KHTML, like Gecko) Chrome/0.2.149.27 Safari/525.13", "Mozilla/5.0 (Windows; U; Windows NT 5.2; en-US) AppleWebKit/525.13 (KHTML, like Gecko) Chrome/0.2.149.27 Safari/525.13", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US) AppleWebKit/525.13(KHTML, like Gecko) Chrome/0.2.149.27 Safari/525.13", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US) AppleWebKit/525.13 (KHTML, like Gecko) Chrome/0.2.149.27 Safari/525.13", "Mozilla/5.0 (Windows; U; Windows NT 5.0; en-US) AppleWebKit/525.13 (KHTML, like Gecko) Chrome/0.2.149.27 Safari/525.13", "Mozilla/5.0 (Linux; U; en-US) AppleWebKit/525.13 (KHTML, like Gecko) Chrome/0.2.149.27 Safari/525.13", "Mozilla/5.0 (Macintosh; U; Mac OS X 10_6_1; en-US) AppleWebKit/530.5 (KHTML, like Gecko) Chrome/ Safari/530.5", "Mozilla/5.0 (Macintosh; U; Mac OS X 10_5_7; en-US) AppleWebKit/530.5 (KHTML, like Gecko) Chrome/ Safari/530.5", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_6; en-US) AppleWebKit/530.9 (KHTML, like Gecko) Chrome/ Safari/530.9", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_6; en-US) AppleWebKit/530.6 (KHTML, like Gecko) Chrome/ Safari/530.6", "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_5_6; en-US) AppleWebKit/530.5 (KHTML, like Gecko) Chrome/ Safari/530.5", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:40.0) Gecko/20100101 Firefox/40.1", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:39.0) Gecko/20100101 Firefox/39.0", "Mozilla/5.0 (Windows NT 6.3; rv:36.0) Gecko/20100101 Firefox/36.0", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10; rv:33.0) Gecko/20100101 Firefox/33.0", "Mozilla/5.0 (X11; Linux i586; rv:31.0) Gecko/20100101 Firefox/31.0", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:31.0) Gecko/20130401 Firefox/31.0", "Mozilla/5.0 (Windows NT 5.1; rv:31.0) Gecko/20100101 Firefox/31.0", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:29.0) Gecko/20120101 Firefox/29.0", "Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:25.0) Gecko/20100101 Firefox/29.0", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:42.0) Gecko/20100101 Firefox/42.0"};

    public String post(String payload) throws Exception {
        return this.post("http://poe.trade/search", payload);
    }

    public String post(String url, String payload) throws Exception {
        Header[] allHeaders;
        this.logger.info("post() payload: " + payload);
        this.logger.info("post() url: " + url);
        HttpPost post = new HttpPost(url);
        post.setConfig(this.requestConfig);
        post.setHeader("Host", "poe.trade");
        post.setHeader("User-Agent", USER_AGENT);
        post.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        post.setHeader("Accept-Language", "en-US,en;q=0.5");
        post.setHeader("Accept-Encoding", "gzip, deflate");
        post.setHeader("Referer", "http://poe.trade/");
        post.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        post.setHeader("Connection", "keep-alive");
        post.setEntity(new StringEntity(payload));
        this.logger.info("Sending 'POST' request to URL : " + url);
        HttpResponse response = this.postWithRetry(post);
        int responseCode = response.getStatusLine().getStatusCode();
        this.logger.info("Response Code : " + responseCode);
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
        StringBuilder result = new StringBuilder();
        String line = "";
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        rd.close();
        String location = null;
        for (Header header : allHeaders = response.getAllHeaders()) {
            if (!header.getName().equalsIgnoreCase("Location")) continue;
            location = header.getValue();
        }
        boolean captchaDetected = this.containsCaptchaKeyword(result.toString());
        if (captchaDetected) {
            throw new CaptchaDetectedException(location);
        }
        return location;
    }

    private boolean containsCaptchaKeyword(String line) {
        return line.contains("recaptcha/api.js");
    }

    public String postXMLHttpRequest(String url, String payload) throws Exception {
        this.logger.info("postXMLHttpRequest() payload: " + payload);
        this.logger.info("postXMLHttpRequest() url: " + url);
        StringEntity entity = new StringEntity(payload);
        HttpPost post = new HttpPost(url);
        post.setConfig(this.requestConfig);
        post.setHeader("Accept", "*/*");
        post.setHeader("Accept-Encoding", "gzip, deflate");
        post.setHeader("Accept-Language", "en-US,en;q=0.5");
        post.setHeader("Cache-Control", "no-cache");
        post.setHeader("Connection", "keep-alive");
        post.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        post.setHeader("Host", "poe.trade");
        post.setHeader("Pragma", "no-cache");
        post.setHeader("Referer", url);
        post.setHeader("User-Agent", USER_AGENT);
        post.setHeader("X-Requested-With", "XMLHttpRequest");
        post.setEntity(entity);
        this.logger.info("Sending 'POST' request to URL : " + url);
        HttpResponse response = this.postWithRetry(post);
        int responseCode = response.getStatusLine().getStatusCode();
        this.logger.info("Response Code : " + responseCode);
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
        StringBuilder result = new StringBuilder();
        String line = "";
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        rd.close();
        boolean captchaDetected = this.containsCaptchaKeyword(result.toString());
        if (captchaDetected) {
            throw new CaptchaDetectedException(url);
        }
        return result.toString();
    }

    public String get(String url) throws Exception {
        HttpGet get = new HttpGet(url);
        get.setConfig(this.requestConfig);
        get.setHeader("Host", "poe.trade");
        get.setHeader("User-Agent", USER_AGENT);
        get.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        get.setHeader("Accept-Language", "en-US,en;q=0.5");
        get.setHeader("Accept-Encoding", "gzip, deflate");
        get.setHeader("Referer", "http://poe.trade/");
        get.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        HttpResponse response = this.client.execute(get);
        int responseCode = response.getStatusLine().getStatusCode();
        this.logger.info("Sending 'GET' request to URL : " + url);
        this.logger.info("Response Code : " + responseCode);
        BufferedReader rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), "UTF-8"));
        StringBuilder result = new StringBuilder();
        String line = "";
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        rd.close();
        return result.toString();
    }

    private HttpResponse postWithRetry(HttpPost post) throws IOException, ClientProtocolException {
        int count = 0;
        int maxTries = 10;
        while (true) {
            try {
                return this.client.execute(post);
            }
            catch (Exception e) {
                this.logger.info(String.format("Http post failed, gonna try again. Number of retries so far: %d", ++count));
                if (count != maxTries) continue;
                String msg = String.format("Http post failed after %d max retries.", maxTries);
                this.logger.info(msg);
                throw new RuntimeException(msg, e);
            }
            break;
        }
    }
}

