/*
 * Decompiled with CFR 0.152.
 */
package com.porty.swing.util;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;

public class WindowUtils {
    public static Point getPointForCentering(Window window) {
        try {
            GraphicsDevice[] devices;
            Point mousePoint = MouseInfo.getPointerInfo().getLocation();
            for (GraphicsDevice device : devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                if (mousePoint.x < bounds.x || mousePoint.y < bounds.y || mousePoint.x > bounds.x + bounds.width || mousePoint.y > bounds.y + bounds.height) continue;
                int screenWidth = bounds.width;
                int screenHeight = bounds.height;
                int width = window.getWidth();
                int height = window.getHeight();
                return new Point((screenWidth - width) / 2 + bounds.x, (screenHeight - height) / 2 + bounds.y);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("unable to access window bounds", e);
        }
        return new Point(0, 0);
    }

    public static void centerWindow(Window frame) {
        frame.setLocation(WindowUtils.getPointForCentering(frame));
    }

    public static Rectangle getScreenRect() {
        int n = 0;
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        GraphicsDevice[] graphicsDeviceArray = devices;
        int n2 = graphicsDeviceArray.length;
        if (n < n2) {
            GraphicsDevice device = graphicsDeviceArray[n];
            Rectangle bounds = device.getDefaultConfiguration().getBounds();
            return bounds;
        }
        return new Rectangle();
    }
}

