/*
 * Decompiled with CFR 0.152.
 */
package com.porty.swing.util;

import java.awt.Dimension;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class LayoutUtils {
    private static JLabel dummyComponent = new JLabel("foo");
    private static JTextField dummyTextfield = new JTextField(10);
    private static JPanel dummyContainer = new JPanel();

    public static int getGenericContainerGap() {
        return LayoutStyle.getInstance().getContainerGap(dummyComponent, 1, dummyContainer);
    }

    public static int getGenericRelatedGap() {
        return LayoutStyle.getInstance().getPreferredGap(dummyComponent, dummyTextfield, LayoutStyle.ComponentPlacement.RELATED, 3, dummyContainer);
    }

    public static int getGenericUnrelatedGap() {
        return LayoutStyle.getInstance().getPreferredGap(dummyComponent, dummyTextfield, LayoutStyle.ComponentPlacement.UNRELATED, 1, dummyContainer);
    }

    public static void setSameAlignmentX(float alignment, JComponent ... comps) {
        for (JComponent comp : comps) {
            comp.setAlignmentX(alignment);
        }
    }

    public static void makeSamePreferredWidth(JComponent ... comps) {
        if (comps.length == 0) {
            return;
        }
        Arrays.sort(comps, new Comparator<JComponent>(){

            @Override
            public int compare(JComponent o1, JComponent o2) {
                return o1.getPreferredSize().width - o2.getPreferredSize().width;
            }
        });
        int biggest = comps[comps.length - 1].getPreferredSize().width;
        for (JComponent comp : comps) {
            comp.setPreferredSize(new Dimension(biggest, comp.getPreferredSize().height));
            comp.setMaximumSize(new Dimension(biggest, comp.getMaximumSize().height));
            comp.setMinimumSize(new Dimension(biggest, comp.getMinimumSize().height));
        }
    }
}

