/*
 * Decompiled with CFR 0.152.
 */
package com.porty.swing.table.model;

import com.porty.swing.util.DynamicBeanUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class BeanPropertyTableModel<T>
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private final Class beanClass;
    private List<T> data = new ArrayList<T>();
    private List<PropertyDescriptor> columns = new ArrayList<PropertyDescriptor>();
    private List<String> columnNames = new ArrayList<String>();
    private ResourceBundle resourceBundle;
    private String resourcePrefix;
    private Set<String> excludeProperties = new HashSet<String>();
    private List<String> orderedProperties = new ArrayList<String>();
    private Map<String, Integer> propertiesIndexes = new HashMap<String, Integer>();

    public BeanPropertyTableModel(Class beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("Bean class required, cannot be null");
        }
        this.beanClass = beanClass;
        this.addExcludedProperty("class");
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        this.data = data;
        this.fireTableDataChanged();
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void setResourcePrefix(String resourcePrefix) {
        this.resourcePrefix = resourcePrefix;
    }

    public void addExcludedProperty(String propertyName) {
        this.excludeProperties.add(propertyName);
    }

    public void setOrderedProperties(List<String> orderedProperties) {
        this.orderedProperties = orderedProperties;
    }

    public void setOrderedPropertiesFromResource(Class base, String resourceName) {
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(base.getResourceAsStream(resourceName), "UTF8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        String nextLine = null;
        try {
            while ((nextLine = reader.readLine()) != null) {
                result.add(nextLine.trim());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.setOrderedProperties(result);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        if (this.columns.isEmpty()) {
            this.populateColumns();
        }
        return this.columns.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columns.get(columnIndex).getPropertyType();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PropertyDescriptor descriptor = this.columns.get(columnIndex);
        T bean = this.data.get(rowIndex);
        return DynamicBeanUtils.getPropertyValue(bean, descriptor);
    }

    public void populateColumns() {
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(this.beanClass);
        }
        catch (IntrospectionException ex) {
            throw new RuntimeException("Unable to introspect dynamic table data class", ex);
        }
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        int columnIndex = 0;
        for (String nextOrderedProp : this.orderedProperties) {
            for (PropertyDescriptor nextDescriptor : pds) {
                if (!nextDescriptor.getName().equals(nextOrderedProp) || !this.addColumnFromProperty(nextDescriptor)) continue;
                this.propertiesIndexes.put(nextOrderedProp, columnIndex++);
            }
        }
        for (PropertyDescriptor nextDescriptor : pds) {
            if (this.propertiesIndexes.containsKey(nextDescriptor.getName()) || !this.addColumnFromProperty(nextDescriptor)) continue;
            this.propertiesIndexes.put(nextDescriptor.getName(), columnIndex++);
        }
    }

    protected boolean addColumnFromProperty(PropertyDescriptor descriptor) {
        if (!this.excludeProperties.contains(descriptor.getName()) && descriptor.getReadMethod() != null) {
            this.columns.add(descriptor);
            this.columnNames.add(this.getColumnName(descriptor.getName()));
            return true;
        }
        return false;
    }

    protected String getColumnName(String propertyName) {
        if (this.resourceBundle != null && this.resourcePrefix != null) {
            String bundleString = this.resourcePrefix + "." + propertyName;
            if (this.resourceBundle.containsKey(bundleString)) {
                return this.resourceBundle.getString(bundleString);
            }
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Resource bundle does not contain property name: {0}", bundleString);
        }
        return this.convertPropertyToColumnName(propertyName);
    }

    protected String convertPropertyToColumnName(String name) {
        String propertyNameCap = name.substring(0, 1).toUpperCase() + name.substring(1);
        String value = "";
        int lastIdx = 0;
        for (int i = 1; i < propertyNameCap.length(); ++i) {
            if (!Character.isUpperCase(propertyNameCap.charAt(i))) continue;
            value = value + propertyNameCap.substring(lastIdx, i) + " ";
            lastIdx = i;
        }
        value = value + propertyNameCap.substring(lastIdx, propertyNameCap.length());
        return value;
    }
}

